#include <cstdio>
#include <vector>
#include <queue>
using namespace std;

const int kMaxN = 1e5 + 10;
const int INF = 1e9;

int n;
int a[kMaxN];
int b[kMaxN];

int t[kMaxN];

void TreeUpdate(int pos, int value)
{
    for (int cur_pos = pos; cur_pos < n; cur_pos |= (cur_pos + 1)) {
        t[cur_pos] = min(t[cur_pos], value);
    }
}

int TreeGet(int pos)
{
    int result = INF;
    for (; pos >= 0; pos = (pos & (pos + 1)) - 1) {
        result = min(result, t[pos]);
    }
    return result;
}

int main()
{
    int tests;
    scanf("%d", &tests);
    for (int test = 0; test < tests; ++test) {
        scanf("%d", &n);
        for (int i = 0; i < n; ++i) {
            int r1, r2, r3;
            scanf("%d%d%d", &r1, &r2, &r3);
            --r1; --r2; --r3;
            a[r1] = r2;
            b[r1] = r3;
        }
        for (int i = 0; i < n; ++i) {
            t[i] = INF;
        }

        int answer = 0;
        for (int i = 0; i < n; ++i) {
            int value = TreeGet(a[i]);

            if (value > b[i]) {
                ++answer;
            }

            TreeUpdate(a[i], b[i]);
        }
        printf("%d\n", answer);
    }


    return 0;
}
